/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.farmer;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.tileentities.AbstractScarecrowTileEntity;
import com.minecolonies.api.tileentities.ScarecrowFieldStage;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.blocks.BlockScarecrow;
import com.minecolonies.coremod.colony.buildings.modules.FarmerFieldModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFarmer;
import com.minecolonies.coremod.colony.interactionhandling.PosBasedInteraction;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobFarmer;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import com.minecolonies.coremod.network.messages.client.CompostParticleMessage;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import com.minecolonies.coremod.util.AdvancementUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkFarmer
extends AbstractEntityAICrafting<JobFarmer, BuildingFarmer> {
    private static final int MAX_BLOCKS_MINED = 64;
    private static final int STANDARD_DELAY = 40;
    private static final int SMALLEST_DELAY = 1;
    private static final double DELAY_DIVIDER = 1.0;
    private static final double XP_PER_HARVEST = 0.5;
    private static final VisibleCitizenStatus FARMING_ICON = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/farmer.png"), "com.minecolonies.gui.visiblestatus.farmer");
    private boolean shouldDumpInventory = false;
    @Nullable
    private BlockPos workingOffset;
    @Nullable
    private BlockPos prevPos;
    private int cell = -1;

    public EntityAIWorkFarmer(@NotNull JobFarmer job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, () -> AIWorkerState.START_WORKING, 10), new AITarget((IAIState)AIWorkerState.PREPARING, this::prepareForFarming, 20), new AITarget((IAIState)AIWorkerState.FARMER_HOE, this::workAtField, 5), new AITarget((IAIState)AIWorkerState.FARMER_PLANT, this::workAtField, 5), new AITarget((IAIState)AIWorkerState.FARMER_HARVEST, this::workAtField, 5));
        this.worker.func_98053_h(true);
    }

    @Override
    public Class<BuildingFarmer> getExpectedBuildingClass() {
        return BuildingFarmer.class;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 64;
    }

    @Override
    protected int getActionRewardForCraftingSuccess() {
        return 64;
    }

    @Override
    protected IAIState decide() {
        IAIState nextState = super.decide();
        if (nextState != AIWorkerState.START_WORKING) {
            return nextState;
        }
        if (this.wantInventoryDumped()) {
            return this.getState();
        }
        if (((JobFarmer)this.job).getTaskQueue().isEmpty()) {
            return AIWorkerState.PREPARING;
        }
        if (((JobFarmer)this.job).getCurrentTask() == null) {
            return AIWorkerState.PREPARING;
        }
        if (this.currentRequest != null && this.currentRecipeStorage != null) {
            return AIWorkerState.QUERY_ITEMS;
        }
        return AIWorkerState.GET_RECIPE;
    }

    @NotNull
    private IAIState prepareForFarming() {
        int amountOfCompostInInv;
        int amountOfCompostInBuilding;
        BuildingFarmer building = (BuildingFarmer)this.getOwnBuilding();
        if (building == null || building.getBuildingLevel() < 1) {
            return AIWorkerState.PREPARING;
        }
        if (!((JobFarmer)this.job).getTaskQueue().isEmpty() || this.getActionsDoneUntilDumping() <= ((JobFarmer)this.job).getActionsDone()) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        FarmerFieldModule module = building.getFirstModuleOccurance(FarmerFieldModule.class);
        module.syncWithColony(this.world);
        if (module.getFarmerFields().size() < ((BuildingFarmer)this.getOwnBuilding()).getBuildingLevel() && !module.assignManually()) {
            this.searchAndAddFields();
        }
        if (module.getFarmerFields().size() == ((BuildingFarmer)this.getOwnBuilding()).getMaxBuildingLevel()) {
            AdvancementUtils.TriggerAdvancementPlayersForColony(building.getColony(), AdvancementTriggers.MAX_FIELDS::trigger);
        }
        if ((amountOfCompostInBuilding = InventoryUtils.getCountFromBuilding(this.getOwnBuilding(), this::isCompost)) + (amountOfCompostInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isCompost)) <= 0) {
            if (((BuildingFarmer)this.getOwnBuilding()).requestFertilizer() && !((BuildingFarmer)this.getOwnBuilding()).hasWorkerOpenRequestsOfType(this.worker.getCitizenData().getId(), TypeToken.of(StackList.class))) {
                ArrayList<ItemStack> compostAbleItems = new ArrayList<ItemStack>();
                compostAbleItems.add(new ItemStack((IItemProvider)ModItems.compost, 1));
                compostAbleItems.add(new ItemStack((IItemProvider)Items.field_196106_bc, 1));
                this.worker.getCitizenData().createRequestAsync(new StackList(compostAbleItems, "com.minecolonies.coremod.request.fertilizer", 64, 1));
            }
        } else if (amountOfCompostInInv <= 0 && amountOfCompostInBuilding > 0) {
            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(this::isCompost, 64);
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        if (module.hasNoFields()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("entity.farmer.nofreefields"), ChatPriority.BLOCKING));
            }
            this.worker.getCitizenData().setIdleAtJob(true);
            return AIWorkerState.PREPARING;
        }
        this.worker.getCitizenData().setIdleAtJob(false);
        if (module.getCurrentField() == null && module.getFieldToWorkOn(this.world) == null) {
            module.resetFields();
            return AIWorkerState.IDLE;
        }
        BlockPos currentField = module.getCurrentField();
        TileEntity entity = this.world.func_175625_s(currentField);
        if (entity instanceof ScarecrowTileEntity && ((ScarecrowTileEntity)entity).needsWork()) {
            if (((ScarecrowTileEntity)entity).getFieldStage() == ScarecrowFieldStage.PLANTED && this.checkIfShouldExecute((ScarecrowTileEntity)entity, this::shouldHarvest)) {
                return AIWorkerState.FARMER_HARVEST;
            }
            if (((ScarecrowTileEntity)entity).getFieldStage() == ScarecrowFieldStage.HOED) {
                return this.canGoPlanting((ScarecrowTileEntity)entity, building);
            }
            if (((ScarecrowTileEntity)entity).getFieldStage() == ScarecrowFieldStage.EMPTY && this.checkIfShouldExecute((ScarecrowTileEntity)entity, pos -> this.shouldHoe((BlockPos)pos, (ScarecrowTileEntity)entity))) {
                return AIWorkerState.FARMER_HOE;
            }
            ((ScarecrowTileEntity)entity).nextState();
        } else {
            module.setCurrentField(null);
        }
        return AIWorkerState.PREPARING;
    }

    private boolean isCompost(ItemStack itemStack) {
        if (itemStack.func_77973_b() == ModItems.compost) {
            return true;
        }
        return itemStack.func_77973_b() == Items.field_196106_bc;
    }

    private void searchAndAddFields() {
        AbstractScarecrowTileEntity newField;
        IColony colony = this.worker.getCitizenColonyHandler().getColony();
        if (colony != null && (newField = colony.getBuildingManager().getFreeField(this.worker.getCitizenData().getId(), this.world)) != null) {
            newField.setOwner(this.worker.getCitizenData().getId());
            newField.setTaken(true);
            newField.func_70296_d();
            FarmerFieldModule module = ((BuildingFarmer)this.getOwnBuilding()).getFirstModuleOccurance(FarmerFieldModule.class);
            module.addFarmerFields(newField.getPosition());
        }
    }

    private boolean checkIfShouldExecute(@NotNull ScarecrowTileEntity field, @NotNull Predicate<BlockPos> predicate) {
        BlockPos position;
        do {
            this.workingOffset = this.nextValidCell(field);
            if (this.workingOffset != null) continue;
            return false;
        } while (!predicate.test(position = field.func_174877_v().func_177977_b().func_177970_e(this.workingOffset.func_177952_p()).func_177965_g(this.workingOffset.func_177958_n())));
        return true;
    }

    private IAIState canGoPlanting(@NotNull ScarecrowTileEntity currentField, @NotNull BuildingFarmer buildingFarmer) {
        if (currentField.getSeed() == null || currentField.getSeed().func_190926_b()) {
            this.worker.getCitizenData().triggerInteraction(new PosBasedInteraction((ITextComponent)new TranslationTextComponent("entity.farmer.noseedset", new Object[]{currentField.func_174877_v()}), ChatPriority.BLOCKING, (ITextComponent)new TranslationTextComponent("entity.farmer.noseedset"), currentField.func_174877_v()));
            FarmerFieldModule module = buildingFarmer.getFirstModuleOccurance(FarmerFieldModule.class);
            module.setCurrentField(null);
            this.worker.getCitizenData().setIdleAtJob(true);
            return AIWorkerState.PREPARING;
        }
        this.worker.getCitizenData().setIdleAtJob(false);
        ItemStack seeds = currentField.getSeed().func_77946_l();
        int slot = this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(seeds.func_77973_b());
        if (slot != -1) {
            return AIWorkerState.FARMER_PLANT;
        }
        if (this.walkToBuilding()) {
            return AIWorkerState.PREPARING;
        }
        seeds.func_190920_e(seeds.func_77976_d());
        this.checkIfRequestForItemExistOrCreateAsynch(seeds, seeds.func_77976_d(), 1);
        currentField.nextState();
        return AIWorkerState.PREPARING;
    }

    private boolean shouldHoe(@NotNull BlockPos position, @NotNull ScarecrowTileEntity field) {
        return !field.isNoPartOfField(this.world, position) && !(this.world.func_180495_p(position.func_177984_a()).func_177230_c() instanceof CropsBlock) && !(this.world.func_180495_p(position.func_177984_a()).func_177230_c() instanceof BlockScarecrow) && (this.world.func_180495_p(position).func_177230_c().func_203417_a((ITag)Tags.Blocks.DIRT) || this.world.func_180495_p(position).func_177230_c() instanceof GrassBlock);
    }

    protected BlockPos nextValidCell(AbstractScarecrowTileEntity field) {
        int x;
        int z;
        if (this.workingOffset == null) {
            this.cell = -1;
        }
        do {
            if (++this.cell == this.getLargestCell()) {
                return null;
            }
            int ring = (int)Math.floor((Math.sqrt(this.cell + 1) + 1.0) / 2.0);
            int ringCell = this.cell - (int)(4.0 * Math.pow(ring - 1, 2.0) + (double)(4 * (ring - 1)));
            Direction facing = Direction.func_176731_b((int)Math.floorDiv(ringCell, 2 * ring));
            if (facing.func_176740_k() == Direction.Axis.Z) {
                x = (facing == Direction.NORTH ? -1 : 1) * (ring - ringCell % (2 * ring));
                z = (facing == Direction.NORTH ? -1 : 1) * ring;
                continue;
            }
            x = (facing == Direction.WEST ? -1 : 1) * ring;
            z = (facing == Direction.EAST ? -1 : 1) * (ring - ringCell % (2 * ring));
        } while (-z > field.getRadius(Direction.NORTH) || x > field.getRadius(Direction.EAST) || z > field.getRadius(Direction.SOUTH) || -x > field.getRadius(Direction.WEST));
        return new BlockPos(x, 0, z);
    }

    protected int getLargestCell() {
        return (int)Math.pow(ScarecrowTileEntity.getMaxRange() * 2 + 1, 2.0);
    }

    @Override
    protected boolean wantInventoryDumped() {
        if (this.shouldDumpInventory || this.job != null && ((JobFarmer)this.job).getActionsDone() >= this.getActionRewardForCraftingSuccess()) {
            this.shouldDumpInventory = false;
            return true;
        }
        return super.wantInventoryDumped();
    }

    private IAIState workAtField() {
        BuildingFarmer buildingFarmer = (BuildingFarmer)this.getOwnBuilding();
        FarmerFieldModule module = buildingFarmer.getFirstModuleOccurance(FarmerFieldModule.class);
        if (this.checkForToolOrWeapon(ToolType.HOE) || module.getCurrentField() == null) {
            return AIWorkerState.PREPARING;
        }
        this.worker.getCitizenData().setVisibleStatus(FARMING_ICON);
        BlockPos field = module.getCurrentField();
        TileEntity entity = this.world.func_175625_s(field);
        if (entity instanceof ScarecrowTileEntity) {
            ScarecrowTileEntity scarecrow = (ScarecrowTileEntity)entity;
            if (this.workingOffset != null) {
                if (scarecrow.getOwnerId() != this.worker.getCivilianID()) {
                    module.freeField(module.getCurrentField());
                    module.setCurrentField(null);
                    return this.getState();
                }
                BlockPos position = field.func_177977_b().func_177970_e(this.workingOffset.func_177952_p()).func_177965_g(this.workingOffset.func_177958_n());
                if (this.walkToBlock(position.func_177984_a())) {
                    return this.getState();
                }
                switch ((AIWorkerState)this.getState()) {
                    case FARMER_HOE: {
                        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.hoeing")});
                        if (this.hoeIfAble(position, scarecrow)) break;
                        return this.getState();
                    }
                    case FARMER_PLANT: {
                        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.planting")});
                        if (this.tryToPlant(scarecrow, position)) break;
                        return AIWorkerState.PREPARING;
                    }
                    case FARMER_HARVEST: {
                        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.harvesting")});
                        if (this.harvestIfAble(position)) break;
                        return this.getState();
                    }
                    default: {
                        return AIWorkerState.PREPARING;
                    }
                }
                this.prevPos = position;
                this.setDelay(this.getLevelDelay());
            }
            this.workingOffset = this.nextValidCell(scarecrow);
            if (this.workingOffset == null) {
                this.shouldDumpInventory = true;
                scarecrow.nextState();
                this.prevPos = null;
                return AIWorkerState.IDLE;
            }
        } else {
            return AIWorkerState.IDLE;
        }
        return this.getState();
    }

    private boolean hoeIfAble(BlockPos position, ScarecrowTileEntity field) {
        if (this.shouldHoe(position, field) && !this.checkForToolOrWeapon(ToolType.HOE)) {
            if (this.mineBlock(position.func_177984_a())) {
                this.equipHoe();
                this.worker.func_184609_a(this.worker.func_184600_cs());
                this.world.func_175656_a(position, Blocks.field_150458_ak.func_176223_P());
                this.worker.getCitizenItemHandler().damageItemInHand(Hand.MAIN_HAND, 1);
                this.worker.decreaseSaturationForContinuousAction();
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public int getBreakSpeedLevel() {
        return this.getSecondarySkillLevel();
    }

    private boolean harvestIfAble(BlockPos position) {
        if (this.shouldHarvest(position)) {
            if (Compatibility.isPamsInstalled()) {
                this.worker.getCitizenExperienceHandler().addExperience(0.5);
                this.harvestCrop(position.func_177984_a());
                return true;
            }
            if (this.mineBlock(position.func_177984_a())) {
                this.worker.getCitizenExperienceHandler().addExperience(0.5);
            } else {
                return false;
            }
        }
        return true;
    }

    protected int getLevelDelay() {
        return (int)Math.max(1.0, 40.0 - (double)this.getPrimarySkillLevel() / 2.0 * 1.0);
    }

    private boolean tryToPlant(ScarecrowTileEntity field, BlockPos position) {
        return !this.shouldPlant(position, field) || this.plantCrop(field.getSeed(), position);
    }

    private void equipHoe() {
        this.worker.getCitizenItemHandler().setHeldItem(Hand.MAIN_HAND, this.getHoeSlot());
    }

    private boolean shouldPlant(@NotNull BlockPos position, @NotNull ScarecrowTileEntity field) {
        return !field.isNoPartOfField(this.world, position) && !(this.world.func_180495_p(position.func_177984_a()).func_177230_c() instanceof CropsBlock) && !(this.world.func_180495_p(position.func_177984_a()).func_177230_c() instanceof StemBlock) && !(this.world.func_180495_p(position).func_177230_c() instanceof BlockScarecrow) && this.world.func_180495_p(position).func_177230_c() instanceof FarmlandBlock;
    }

    private boolean plantCrop(ItemStack item, @NotNull BlockPos position) {
        if (item == null || item.func_190926_b()) {
            return false;
        }
        int slot = this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(item.func_77973_b());
        if (slot == -1) {
            return false;
        }
        if (item.func_77973_b() instanceof BlockItem && (((BlockItem)item.func_77973_b()).func_179223_d() instanceof CropsBlock || ((BlockItem)item.func_77973_b()).func_179223_d() instanceof StemBlock)) {
            Item seed = item.func_77973_b();
            if (!(seed != Items.field_151081_bc && seed != Items.field_151080_bb || this.prevPos == null || this.world.func_175623_d(this.prevPos.func_177984_a()))) {
                return true;
            }
            this.world.func_175656_a(position.func_177984_a(), ((BlockItem)item.func_77973_b()).func_179223_d().func_176223_P());
            this.worker.decreaseSaturationForContinuousAction();
            this.getInventory().extractItem(slot, 1, false);
        }
        return true;
    }

    private boolean shouldHarvest(@NotNull BlockPos position) {
        BlockState state = this.world.func_180495_p(position.func_177984_a());
        Block block = state.func_177230_c();
        if (block == Blocks.field_150423_aK || block == Blocks.field_150440_ba) {
            return true;
        }
        if (this.isCrop(block)) {
            CropsBlock crop = (CropsBlock)block;
            if (crop.func_185525_y(state)) {
                return true;
            }
            int amountOfCompostInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isCompost);
            if (amountOfCompostInInv == 0) {
                return false;
            }
            if (InventoryUtils.shrinkItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isCompost)) {
                Network.getNetwork().sendToPosition(new CompostParticleMessage(position.func_177984_a()), new PacketDistributor.TargetPoint((double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), 16.0, this.world.func_234923_W_()));
                crop.func_176487_g(this.world, position.func_177984_a(), state);
                state = this.world.func_180495_p(position.func_177984_a());
                block = state.func_177230_c();
                if (this.isCrop(block)) {
                    crop = (CropsBlock)block;
                } else {
                    return false;
                }
            }
            return crop.func_185525_y(state);
        }
        return false;
    }

    public boolean isCrop(Block block) {
        return block instanceof CropsBlock;
    }

    @Override
    protected List<ItemStack> increaseBlockDrops(List<ItemStack> drops) {
        if (this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.FARMING) > 0.0) {
            return drops;
        }
        ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
        for (ItemStack stack : drops) {
            ItemStack drop = stack.func_77946_l();
            if (this.worker.func_70681_au().nextDouble() < this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.FARMING)) {
                drop.func_190920_e(drop.func_190916_E() * 2);
            }
            newDrops.add(drop);
        }
        return newDrops;
    }

    private void harvestCrop(@NotNull BlockPos pos) {
        ItemStack tool = this.worker.func_184614_ca();
        int fortune = ItemStackUtils.getFortuneOf(tool);
        BlockState state = this.world.func_180495_p(pos);
        double chance = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.FARMING);
        NonNullList drops = NonNullList.func_191196_a();
        state.func_215693_a(new LootContext.Builder((ServerWorld)this.world).func_186469_a((float)fortune).func_186469_a((float)fortune).func_216015_a(LootParameters.field_237457_g_, (Object)this.worker.func_213303_ch()).func_216015_a(LootParameters.field_216289_i, (Object)tool).func_216015_a(LootParameters.field_216281_a, (Object)this.getCitizen()));
        for (ItemStack item : drops) {
            ItemStack drop = item.func_77946_l();
            if (this.worker.func_70681_au().nextDouble() < chance) {
                drop.func_190920_e(drop.func_190916_E() * 2);
            }
            InventoryUtils.addItemStackToItemHandler((IItemHandler)this.worker.getInventoryCitizen(), drop);
        }
        if (state.func_177230_c() instanceof CropsBlock) {
            CropsBlock crops = (CropsBlock)state.func_177230_c();
            this.world.func_175656_a(pos, crops.func_185528_e(0));
        }
        this.incrementActionsDone();
        this.worker.decreaseSaturationForContinuousAction();
    }

    private int getHoeSlot() {
        return InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)this.getInventory(), ToolType.HOE, 0, ((BuildingFarmer)this.getOwnBuilding()).getMaxToolLevel());
    }

    @Nullable
    public AbstractEntityCitizen getCitizen() {
        return this.worker;
    }
}

